# frozen_string_literal: true
require File.expand_path('../../../../../../test_helper', __FILE__)
require 'pdf/reader'

class IssuesPdfRedmineHelperTest <Redmine::HelperTest
  fixtures :issues

  include Redmine::Export::PDF::IssuesPdfHelper

  def test_issue_to_pdf_should_create_attachment_links
    issue = Issue.find(2)
    result = issue_to_pdf(issue)
    pdf_reader = PDF::Reader.new(StringIO.new(result))

    assert pdf_reader.pages.any? { |page| page.text.include?("#{issue.subject}") }, "The expected subject is not present in the PDF"

    issue.attachments.each do |attachment|
      link = link_to_attachment(attachment, {})
      assert_equal(true, result.include?("(http://test.host/attachments/#{attachment.id})"))
    end
  end
end
