class TestActivity < ApplicationRecord
  include Redmine::Acts::ActivityProvider
  include Redmine::Acts::Event

  belongs_to :author, class_name: "User"
  belongs_to :project

  validates :text, presence: true, length: 1..255
  validates :author, presence: true
  validates :project, presence: true

  acts_as_event title: -> (record) { "#{record.text}" },
                description: -> (record) { "#{record.text}" },
                datetime: :created_at,
                url: -> (record) { { } }

  acts_as_activity_provider timestamp: "#{table_name}.created_at",
                            author_key: :author_id,
                            scope: -> { preload(:project) }

  scope :visible, -> (*args) {
    joins(:project).
      where(Project.allowed_to_condition(args.shift || User.current, :view_projects, *args))
  }

  def visible?(user = User.current)
    user.allowed_to?(:view_projects, project)
  end
end
