#!/bin/bash
set -eux

adapter=$1
time_offset=""
if [ "$#" -eq 2 ]; then
  time_offset=$2
fi

# Load test fixtures
bundle exec rake db:drop && bundle exec rake db:create && bundle exec rake db:migrate && \
  bundle exec rake db:fixtures:load

# Save fixtures (1st)
bundle exec rake extract_fixtures DIR=./tmp/fixtures/$adapter-1 TIME_OFFSET=$time_offset

# Load saved fixtures
bundle exec rake db:drop && bundle exec rake db:create && bundle exec rake db:migrate && \
  bundle exec rake db:fixtures:load FIXTURES_PATH=./tmp/fixtures/$adapter-1

# Save fixtures (2nd)
bundle exec rake extract_fixtures DIR=./tmp/fixtures/$adapter-2 TIME_OFFSET=$time_offset

# Check diff
diff -u ./tmp/fixtures/$adapter-1 ./tmp/fixtures/$adapter-2
