require 'benchmark'

Setting.text_formatting = 'common_mark'
Setting.cache_formatted_text = 0

text = <<~MD
| a | b |
|---|---|
| 1 | 2 |

```ruby
def hello
  puts 'hi'
end
```
MD

iter = (ENV['ITER'] || '20').to_i
mult = (ENV['MULT'] || '5').to_i
text = Array.new(mult, text).join("\n")

puts "ruby=#{RUBY_VERSION} iter=#{iter} mult=#{mult}"
puts "commonmarker=#{Gem.loaded_specs['commonmarker']&.version} loofah=#{Gem.loaded_specs['loofah']&.version} rouge=#{Gem.loaded_specs['rouge']&.version}"

# Warm up to avoid measuring one-time initialization costs.
2.times { Redmine::WikiFormatting.to_html('common_mark', text) }

full = Benchmark.realtime do
  iter.times { Redmine::WikiFormatting.to_html('common_mark', text) }
end

puts "full_ms=#{(full*1000).round(2)} avg_full=#{((full/iter)*1000).round(2)}"
