require 'benchmark'

Setting.text_formatting = 'textile'
Setting.cache_formatted_text = 0

text = <<~TXT
|_. a |_. b |
| 1 | 2 |

<pre><code class="ruby">
def hello
  puts 'hi'
end
</code></pre>
TXT

iter = (ENV['ITER'] || '20').to_i
mult = (ENV['MULT'] || '5').to_i
text = Array.new(mult, text).join("\n")

puts "ruby=#{RUBY_VERSION} iter=#{iter} mult=#{mult}"

# Warm up to avoid measuring one-time initialization costs.
2.times { Redmine::WikiFormatting.to_html('textile', text) }

full = Benchmark.realtime do
  iter.times { Redmine::WikiFormatting.to_html('textile', text) }
end

puts "full_ms=#{(full*1000).round(2)} avg_full=#{((full/iter)*1000).round(2)}"
