require 'win32ole'

module Redmine
  module MAPI  
    class << self
      def check(mapi_options={}, options={})

		puts "options: #{options}" if logger && logger.debug?
		puts "mapi_options: #{mapi_options}" if logger && logger.debug?
		mapi = WIN32OLE.new('Mapi.Session')
		
		WIN32OLE.const_load(mapi)

		mailbox = 'MS Exchange Settings'
		logonParam = mailbox
		mapi.Logon(logonParam)	
		
		inbox = mapi.inbox	

		messages = inbox.messages
		
		messages.each do |msg|
			# logger.info "Receiving message: #{message.grep(/^Subject: /)}" if logger && logger.debug?
			puts "Receiving message: #{msg.Subject}" if logger && logger.info?
			
			if MAPIMailHandler.receive(msg, options)
			  logger.info "Message #{msg.Subject} processed -- removing from server." if logger && logger.info?
			  puts "#{msg.Subject}" 
			  puts "--> Message processed and deleted from the server" 
			  msg.delete
			else
			  puts "#{msg.Subject}" 
			  puts "--> Message NOT processed -- leaving it on the server" 
			  logger.info "ERROR: Message #{msg.Subject} can not be processed, leaving on the server." if logger && logger.info?
			end
		end
      end

      private

      def logger
        RAILS_DEFAULT_LOGGER
      end
    end
  end
end
