var timSearchSimilar = null;
var simelement = null;
var lastquery = "";

function updateSimilarIssues(element, response)
{
	var pat = new RegExp(/<a href=\"(\/[a-z]+)?\/issues\/(\d+)\">(.*?) #(\d+) \(([^\)]+)\)\: (.+?)<\/a>/gi);

	var result;
        var similarhtml = '';
        while ((result = pat.exec(response)) != null) 
        {
		similarhtml = similarhtml+ "<tr><td><a target=\"_blank\" href=\"" + result[1] + "/issues/" + result[2] + "\">" + result[3] + " #" + result[2]+"</a></td><td>"+result[6]+"</td><td>"+result[5]+"</td></tr>";
	}

	// NOTE: IE seems to have issues updating elements with HTML and prototype, so this is the only way I could make it work
	if (simelement !== null)
	{
		simelement.remove();
	}
	
	simelement = new Element("div")
	element.insert({after:simelement });
	
		
	if (similarhtml) 
	{
		var divhtml = "<div id='similarissues' style='padding: 5px 0 8px 180px;'><label>Did you mean?<br><span style='font-size:10px; line-height: normal; font-weight: normal'>These issues already exist</span></label><table style='line-height: 1em'>"+similarhtml+"</table></div>";
		simelement.insert(divhtml);
	}
}

function scheduleDupIssueSearch(element)
{
	var thisquery = element.getValue();
	
	if (thisquery == null || thisquery == undefined || lastquery == thisquery)
	{
		return;
	}
	
	lastquery = thisquery;
	
	clearTimeout(timSearchSimilar);
	timSearchSimilar = setTimeout(function() { searchDupIssues(element); }, 400);
}

function searchDupIssues(element)
{
    var proj = location.href.replace(/^.*\/projects\/([^\/]+)\/issues.*$/, '$1');
    var url = "../../../search/index/"+proj+"?issues=1&q="+escape(element.getValue());
    new Ajax.Request(url, {
    	method: 'get',
    	onSuccess: function(transport)
    	{
    		updateSimilarIssues(element, transport.responseText);
    	}    	
    });

}

function findDupIssues()
{

	$$(".new-issue-form #issue_subject").each(function(element)
	{
		element.setAttribute("autocomplete", "off");
		element.observe('keyup', function() {
			scheduleDupIssueSearch(element);
        	});
        	

                element.observe('change', function() {
                     scheduleDupIssueSearch(element);
                });        	
		
	});
	
}

document.observe('dom:loaded', function(){
	findDupIssues();
});



