# redMine - project management software
# Copyright (C) 2006  Jean-Philippe Lang
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

module TimelogHelper
  def select_hours(data, criteria, value)
    data.select {|row| row[criteria] == value.to_s}
  end

  def sum_hours(data)
    sum = 0
    data.each do |row|
      sum += row['hours'].to_f
    end
    sum
  end

  def render_time_entry_tooltip(time_entry)
    @cached_label_comments ||= l(:field_comments)

    issue = time_entry.issue.nil? ? "" : link_to_issue(time_entry.issue) + ": #{h(time_entry.issue.subject)}<br />"
    issue + "<strong>#{@cached_label_comments}</strong>: #{time_entry.comments}"
  end
end
