# redMine - project management software
# Copyright (C) 2006-2007  Jean-Philippe Lang
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

module Redmine
  module Helpers

    #class for calculating personal time entries
    class TimeReportCalendar < Calendar
      def initialize(date, lang = current_language, period = :week2)
        @date = date
        @events = []
        @ending_events_by_days = {}
        @starting_events_by_days = {}

        @time_entries = []
        @spent_time_entries_by_days = {}

        set_language lang

        case period
        when :week2
          @startdt = date - 7 - (date.cwday - first_wday)%7
          @enddt = date + (last_wday - date.cwday)%7
        else
          super(date, lang, period)
        end
      end

      # Sets calendar time_entries
      def time_entries=(time_entries)
        @time_entries = time_entries
        @spent_time_entries_by_days = @time_entries.group_by {|entry| entry.spent_on}
      end

      # Returns time_entries for the given day
      def time_entries_on(day)
        @spent_time_entries_by_days[day] || []
      end

    end

  end
end
