INFINITY = 1.0/0

#selection sort
def sort_issues(issues)
  for i in 0...issues.length do
    list = issues[i...issues.length]
    issue = list.min_by{|issue| issue.start_date ? issue.start_date.to_time.to_i : INFINITY }
    if issue.start_date != nil and issue != issues[i]
      destiny = issue.left_sibling
      issue.move_to_left_of issues[i]

      if destiny != issues[i]
        issues[i].move_to_right_of destiny
      end

      min_index = issues.index(issue)
      issues[i], issues[min_index] = issues[min_index], issues[i]
    end
    sort_issues issue.children
  end
end


def sort_all_issues
  Project.all.each do |project|
    project.issues.each do |issue|
      if issue.root?
        sort_issues(issue.children)
      end
    end
  end
  nil
end

sort_all_issues