#
# settings.rb.example
#
# copy this file to "settings.rb" and modify
# the settings
#

#
# connection data for your bugzilla database
#

BUGZILLA_HOST='localhost'
BUGZILLA_DB='bugs'
BUGZILLA_USER=''
BUGZILLA_PASSWORD=''

#
# connection data for your redmine database
#

REDMINE_HOST='localhost'
REDMINE_DB='redmine'
REDMINE_USER=''
REDMINE_PASSWORD=''

#
# this is the path where the attachments 
# are written to.
# replace this with your redmine attachment path.
# this path is the $redmine_home/files directory.
#

#ATTACHMENT_PATH="/tmp"
ATTACHMENT_PATH="/usr/local/www/redmine/files"

#
# Bugzilla priority to Redmine priority map
# this mapping is language dependent
# if you have been altering your bugzilla settings
# please check the contents of the "priority"-Table 
# in your bugzilla database
#

ISSUE_PRIORITIES = {       
  "P1" => 7,
  "P2" => 6,
  "P3" => 4,
  "P4" => 3,
  "P5" => 3 }

#
# Bugzilla severity to Redmine tracker map
# this mapping is language dependent
# if you have been altering your bugzilla settings
# please check the contents of the "bug_severity"-Table 
# in your bugzilla database
#

ISSUE_TRACKERS = {
  "critical" => 1,
  "trivial" => 1,
  "minimal" => 1,
  "major" => 1,
  "normal" => 1,
  "blocker" => 1,
  "enhancement" => 1,
  "minor" => 1
}

#
# Bugzilla status to Redmine status map
#
# this mapping is language dependent
# if you have been altering your bugzilla settings
# please check the contents of the "bug_status"-Table 
# in your bugzilla database
#

ISSUE_STATUS = {
  "UNCONFIRMED"   => 1,
  "NEW"           => 1,
  "ASSIGNED"      => 2,
  "REOPENED"      => 1,
  "RESOLVED"      => 5,
  "VERIFIED"      => 5,
  "CLOSED"        => 5,
  "INQA"	  => 2
}

#
# Default Role ID for Project Members
#
# In a default Redmine installation the following options are available:
#
# 1: Non member
# 2: Anonymous
# 3: Manager
# 4: Developer
# 5: Reporter

DEFAULT_ROLE_ID = '4'
