#!/usr/bin/php5 -q

<?php

// Requires PHP5 or the file_put_contents() function from PEAR::Compat

$source_dir = "/var/svn";	   // this is a directory with my svn repositories in it
$dest_dir = "/mnt/server/DS/SVN"; // this is where the svn dumps will go
$tmp_dir = "/tmp";		   // temp dir
$hashfile = "/tmp/hash/hashes.txt";// we only back up repositories which have changed
$date = system("date +%Y-%m-%d");

// read in the existing hash file if there is one
$hashes = array();
$hashlines = array();
if (file_exists($hashfile)) {
  $hashlines = file($hashfile);			
}

// build this into an useful array
foreach($hashlines as $hashline) {
  $key = substr($hashline,0,strpos($hashline,":"));
  $value = substr($hashline,strpos($hashline,":")+1);
  if ($key && $value) {
    $hashes[$key] = $value;			
  }
}

system("mkdir $dest_dir/backup");
system("chmod 755 $dest_dir/backup");

// loop through the repositories in the source directory
if ($handle = opendir($source_dir)) {
  while (false !== ($file = readdir($handle))) {
    if (is_dir($source_dir."/".$file) && $file != "." && $file != "..") {
      // generate a md5 hash for the contents of the repository
      $command = "svnlook info '$source_dir/$file'";
      // echo $command."\n";
      exec($command,$output);
      $md5 = trim(md5(trim(str_replace("\n","-",implode("\n",$output)))));
      if (!isset($hashes[$file]) || $hashes[$file] !== $md5) {
        // echo "dumping $file\n";
        $return = system("mkdir -p $tmp_dir/svn_backup/$file");
        $return = system("svnadmin hotcopy $source_dir/$file $tmp_dir/svn_backup/$file");
        $return = system("svnadmin dump -q $tmp_dir/svn_backup/$file | bzip2 -c > $dest_dir/backup/$file.bz2");
        $return = system("rm -Rf $tmp_dir/svn_backup/$file");
        $hashes[$file] = $md5;
      }
    }
  }
  //Compress repositories dumped
  system("tar -cf $dest_dir/$date.tar $dest_dir/backup");
  system("rm -r $dest_dir/backup*");

  //Remove oldest backup
  system("find $dest_dir -amin +6000 -exec rm '{}'");

 closedir($handle);
}

$hashelines = "";
foreach($hashes as $key => $md5) {
  $hashelines .= "$key:$md5\n";
}

file_put_contents($hashfile, $hashelines);

?>
