class AddIssuesNestedSetsColumns < ActiveRecord::Migration
  def self.up
    #add_column :issues, :parent_id, :integer, :default => nil
    add_column :issues, :root_id, :integer, :default => nil
    #add_column :issues, :lft, :integer, :default => nil
    #add_column :issues, :rgt, :integer, :default => nil

    issues=Issue.find(:all)
    args_to_save=Array.new

    say("Issues found: #{issues.size.to_s}")

    issues.each do |issue|
	    if issue.parent_id == nil
		    args=Hash.new
		    args[:parent_id]=0
		    args[:id]=issue.id
		    args[:root_id]=issue.id
		    r=issue.rgt
		    l=issue.lft
		    if (r-l) > 1
			    children=issues.select do |i|
				    true if i.id != issue.id && i.lft > l && i.rgt < r
			    end
			    children.each do |c|
				    c_args=Hash.new
				    c_args[:id]=c.id
				    c_args[:root_id]=issue.id
				    c_args[:lft]=c.lft-(l-1)
				    c_args[:rgt]=c.rgt-(l-1)
				    c_args[:parent_id]=c.parent_id
				    args_to_save << c_args
			    end
			    args[:rgt]=issue.rgt-(l-1)
			    args[:lft]=1
		    else
			    args[:rgt]=2
			    args[:lft]=1
		    end
		    args_to_save << args
	    end
    end

    issues.clear()

    say("Total of #{args_to_save.size.to_s} issues will be affected")

    say_with_time "Migrating issues from IssuesGroup plugin" do
			args_to_save.each_with_index do |a,idx|
				say("Issues processed so far: #{idx.to_s}") if (idx > 0 && idx%1000 == 0)
				update_str="parent_id = #{( a[:parent_id] == 0 ? "NULL" : a[:parent_id].to_s)}, root_id = #{a[:root_id].to_s}, lft = #{a[:lft].to_s}, rgt = #{a[:rgt].to_s}"
				Issue.update_all(update_str,"id = #{a[:id].to_s}")
			end
    end
	  
    #Issue.update_all("parent_id = NULL, root_id = id, lft = 1, rgt = 2")
    #Issue.update_all("root_id = id")
  end

  def self.down
	  raise ActiveRecord::IrreversibleMigration, "Can't roll back parent information"
    #remove_column :issues, :parent_id
    #remove_column :issues, :root_id
    #remove_column :issues, :lft
    #remove_column :issues, :rgt
  end
end
