require_dependency 'issues_helper' 

module IssuesHelperPatch
  def self.included(base) # :nodoc:
    base.send(:include, InstanceMethods)
    base.class_eval do
      unloadable
      alias_method_chain :sidebar_queries, :category
    end
  end
  module InstanceMethods
    def sidebar_queries_with_category
      unless @sidebar_queries
        # User can see public queries and his own queries
        visible = ARCondition.new(["is_public = ? OR user_id = ?", true, (User.current.logged? ? User.current.id : 0)])
        # Project specific queries and global queries
        visible << (@project.nil? ? ["project_id IS NULL"] : ["project_id IS NULL OR project_id = ?", @project.id])
        @sidebar_queries = Query.find(:all,
                                      :order => "name ASC",
                                      :conditions => visible.conditions)
      end
      @sidebar_queries
    end
  end
end
