require 'redmine'
require_dependency 'queries_controller' 

class QueriesController < ApplicationController
	skip_before_filter :find_query, :only => [:autocomplete_for_category]

  def autocomplete_for_category
    @categories = Query.find(:all, :conditions => ["LOWER(category) LIKE ?", "#{params[:category]}%"],
                              :limit => 10,
                              :order => 'category ASC').collect{|q| q.category}.uniq
    render :layout => false
  end
end
