# redMine - project management software
# Copyright (C) 2008  Karl Heinz Marbaise
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

require 'test/unit'
require File.dirname(__FILE__) + '/../../../../lib/tasks/trac/trac_migration'

  class TracMigrationTest < Test::Unit::TestCase

#    def setup
#      @trac = TracMigrate::TracWiki.new()
#    end
    
    # The following three test cases are related to issue #2023
    #   The construct {{{XYZ}}} is not supported by trac.
    #   so the result should be simply the same as the input.
    def test_activity_code_tags_10
      assert_equal("{{{XYZ}}}", TracMigrate::TracWiki.wiki("{{{XYZ}}}"))
    end
  
    #   This construct is valid and would produce the expected output in trac.
    #   The {{{ must be on a separate line and }}} as well.
    def test_activity_code_tags_20
      assert_equal("<pre>\nXYZ\n</pre>", TracMigrate::TracWiki.wiki("{{{\nXYZ\n}}}"))
    end
  
    def test_activity_code_tags_30
      assert_equal("<pre>\n<code class=\"java\">\npublic class test\n</code></pre>", TracMigrate::TracWiki.wiki("{{{\n#!java\npublic class test\n}}}"))
    end
    
    # manual break
    #   The official guide in trac says this is the only way.
    def test_activity_br_10
      assert_equal("\n", TracMigrate::TracWiki.wiki("[[BR]]"))
    end
  
    #   but the lower case variant is working too.
    def test_activity_br_11
      assert_equal("\n", TracMigrate::TracWiki.wiki("[[br]]"))
    end
    
    ## ------------------
    ## Code Highlightings
    ## ------------------
    def test_activity_highlighting_10
      assert_equal("_*HighlightingText*_", TracMigrate::TracWiki.wiki("'''''HighlightingText'''''"))
    end
  
    def test_activity_highlighting_20
      assert_equal("*HighlightingText*", TracMigrate::TracWiki.wiki("'''HighlightingText'''"))
    end
    
    def test_activity_highlighting_30
      assert_equal("_HighlightingText_", TracMigrate::TracWiki.wiki("''HighlightingText''"))
    end
    
    def test_activity_highlighting_40
      assert_equal("+HighlightingText+", TracMigrate::TracWiki.wiki("__HighlightingText__"))
    end
    
    # Milestones
    #   The following test cases are related to issue #2052
    def test_activity_milestone_10
      assert_equal("version:1.0.0", TracMigrate::TracWiki.wiki("milestone:1.0.0"))
    end
    
    def test_activity_milestone_20
      assert_equal('version:"1.0.0"', TracMigrate::TracWiki.wiki('milestone:"1.0.0"'))
    end
    
    def test_activity_milestone_30
      assert_equal('version:"0.1.0 Mercury"', TracMigrate::TracWiki.wiki('[milestone:"0.1.0 Mercury" Milestone 0.1.0 (Mercury)]'))
    end
    
    def test_activity_milestone_40
      assert_equal('version:"Test Milestone X"', TracMigrate::TracWiki.wiki('[milestone:"Test Milestone X"]'))
    end
  
    # Tickets (issue #2053)
    def test_activity_ticket_10
      assert_equal('#123', TracMigrate::TracWiki.wiki('ticket:123'))
    end
  
    def test_activity_ticket_11
      assert_equal('#123', TracMigrate::TracWiki.wiki('#123'))
    end
    
    def test_activity_ticket_20
      assert_equal('#123', TracMigrate::TracWiki.wiki('[ticket:123]'))
    end
  
    def test_activity_ticket_30
      assert_equal('"this":/issues/show/123', TracMigrate::TracWiki.wiki('[ticket:123 this]'))
    end
  
    # Tables (issue #2054)
    def test_activity_tables_10
      assert_equal(
        '|Column1|Column2|Column3|', 
        TracMigrate::TracWiki.wiki('||Column1||Column2||Column3||')
      )
    end
  
    # Tables (issue #2089)
    def test_activity_mailto_10
      assert_equal('user@test.de', TracMigrate::TracWiki.wiki('[mailto:user@test.de]'))
    end
    def test_activity_mailto_20
      assert_equal(
        '"The new text":mailto:user@test.de', 
        TracMigrate::TracWiki.wiki('[mailto:user@test.de The new text]')
      )
    end
  
    #source - tag (issue #2068)
    def test_activity_source_10
      assert_equal(
        'source:/tags/JAGOSI-0.0.10/jagosiapi/src/main/java/com/soebes/jagosi/api/JaGoSI.java@HEAD#L143', 
        TracMigrate::TracWiki.wiki('[source:/tags/JAGOSI-0.0.10/jagosiapi/src/main/java/com/soebes/jagosi/api/JaGoSI.java@latest#L143 Line 143]')
      )
    end
  
    def test_activity_wiki_10
      assert_equal(
        '[[RepositoryQuestions|Have you ever put such questions to your repository]]',
        TracMigrate::TracWiki.wiki('[wiki:RepositoryQuestions Have you ever put such questions to your repository?]')
      )
    end
  
    def test_activity_wiki_20
      assert_equal(
        '* -Scan a whole repository-', 
        TracMigrate::TracWiki.wiki(' * ~~Scan a whole repository~~')
      )
    end
  
    def test_activity_wiki_30
      assert_equal(
        '* -[[Configuration|Cron like automation]] to scan repositories-.', 
        TracMigrate::TracWiki.wiki(' * ~~[wiki:Configuration Cron like automation] to scan repositories~~.')
      )
    end
  
    def test_activity_changeset_10
      assert_equal('r123', TracMigrate::TracWiki.wiki('r123'))
    end
    def test_activity_changeset_20
      assert_equal('r123', TracMigrate::TracWiki.wiki('[123]'))
    end
    def test_activity_changeset_30
      assert_equal('r123', TracMigrate::TracWiki.wiki('changeset:123'))
    end

  
    def test_activity_integration_10
      assert_equal(
        'version:"XXX"+Test+version:"Test Milestone X"', 
        TracMigrate::TracWiki.wiki('[milestone:"XXX"]__Test__[milestone:"Test Milestone X"]')
      )
    end
  end

