class BugsController < ApplicationController
  unloadable
  before_filter :find_project, :authorize, :only => :index

  helper :sort
  include SortHelper
  
  def index
    sort_init 'livello_gravita','asc'
    sort_update %w(id livello_grativa name description)

    logger.info(@project.nil? ? "@project is nil" : "@project name is = #{@project.name}")
    @bugs = Bug.find(:all,:conditions => "title LIKE '%#{@project.name}%'",:order => sort_clause)
   
    #@bugs = Bug.search(@project.name)
    
    flash[:notice] = "nessuna anomalia trovata!" if @bugs.nil? || @bugs.empty?
  end

  #visualizza il dettaglio di una anomalia
  def show
    @bug = Bug.find(params[:id])
    respond_to do |format|
      format.html # show.html.erb
      format.xml  { render :xml => @bug }
    end
  end
  
  def find_project
	@project = Project.find(params[:project_id])
  end

  def list
  end
end
