require_dependency 'issue'

module Redmine_tlcit
  module IssuePatch

    def self.included(base) # :nodoc:
      base.send(:include, InstanceMethods)
      
      base.class_eval do
        unloadable
        #inserire qui relazioni
        has_many :impacts, :dependent => :destroy
        belongs_to :assigned_to_group, :class_name => 'Group', :foreign_key => 'assigned_to_id'
        belongs_to :impacted_by, :class_name => 'Impact', :foreign_key => 'impacted_by_id', :dependent => :destroy
	
        has_many :releasecompositionimpacts,  :foreign_key => 'issue_release_id', :class_name => 'Releasecomposition', :dependent => :destroy
        has_many :issue_impacts, :through => :releasecompositionimpacts
        has_many :releasecompositionreleases,  :foreign_key => 'issue_impact_id', :class_name => 'Releasecomposition', :dependent => :destroy
        has_many :issue_releases, :through => :releasecompositionreleases
        alias_method_chain :validate, :impact
      end
    end

    module InstanceMethods
      def validate_with_impact
        validate_without_impact
        if self.assigned_to_id.nil? and self.tracker_id == Integer(Setting.plugin_redmine_tlcit['id_tracker_impact'])
          errors.add :assigned_to_id, " e' un campo obbligatorio per la scheda Impatto"
        end
      end

    end
  end
end

Issue.send(:include, Redmine_tlcit::IssuePatch)
