require_dependency 'application_helper'

module RedmineTlcit
	module Patches
		module ApplicationHelperPatch
		  def self.included(base) # :nodoc:
			base.send(:include, InstanceMethods)

			base.class_eval do
			unloadable
			end
		  end

		  module InstanceMethods
			def prompt_to_remote(name, text, param, url, html_options = {})
			  html_options[:onclick] = "promptToRemote('#{text}', '#{param}', '#{url_for(url)}'); return false;"
			  link_to name, {}, html_options
			end
		  end
		end
	end
end

unless ApplicationHelper.included_modules.include? RedmineTlcit::Patches::ApplicationHelperPatch
	ApplicationHelper.send(:include, RedmineTlcit::Patches::ApplicationHelperPatch)
end 
