# Patches to the Redmine core
#require 'dispatcher'
ActionDispatch::Callbacks.to_prepare do
  require_dependency 'rate_users_helper_patch' 
  require_dependency 'rate_time_entry_patch' 
  require_dependency 'rate_sort_helper_patch' 
end

# Hooks
require 'rate_project_hook'
require 'rate_memberships_hook'


Redmine::Plugin.register :redmine_rate do
  name 'Rate Plugin'
  author 'Eric Davis'
  url 'https://projects.littlestreamsoftware.com/projects/show/redmine-rate'
  author_url 'http://www.littlestreamsoftware.com'
  description "The Rate plugin provides an API that can be used to find the rate for a Member of a Project at a specific date.  It also stores historical rate data so calculations will remain correct in the future."
  version '0.1.0'

  requires_redmine :version_or_higher => '0.8.0'

   #These settings are set automatically when caching
  settings(:default => {
             'last_caching_run' => nil
           })

  permission :view_rate, { }

  #menu :admin_menu, :rate_caches, { :controller => 'rate_caches', :action => 'index',:id => :redmine_rate}, :caption => :text_rate_caches_panel
end

 

require 'redmine_rate/hooks/timesheet_hook_helper'
require 'redmine_rate/hooks/plugin_timesheet_views_timesheets_time_entry_row_class_hook'
require 'redmine_rate/hooks/plugin_timesheet_views_timesheet_group_header_hook'
require 'redmine_rate/hooks/plugin_timesheet_views_timesheet_time_entry_hook'
require 'redmine_rate/hooks/plugin_timesheet_views_timesheet_time_entry_sum_hook'
require 'redmine_rate/hooks/plugin_timesheet_view_timesheets_report_header_tags_hook'
require 'redmine_rate/hooks/view_layouts_base_html_head_hook'
