require 'redmine'
require_dependency 'query'

Redmine::Plugin.register :redmine_issues_group do
  name 'Redmine Issues Group plugin'
  author 'Andrew Chaika'
  description 'This is a issue group plugin for Redmine'
  version '0.0.2'
end

module QueryPatch
  def self.included(base) # :nodoc:
    # Same as typing in the class 
    base.class_eval do
      unloadable # Send unloadable so it will not be unloaded in development
      serialize :group_by
    end
  end
end

# Add module to Issue
Query.send(:include, QueryPatch)
