/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 * sources get from http://www.pasteshack.net/
 */


var pastedImage, imageContainer, upText, fadePane, statusText, infoText, clipboardCatcher, loader, holder;
var RTEBased = false;
var isPasting = false;
var mouseDown = false;
var topMargin = 140;
var leftMargin = 0;
var cnt=0;
var maxCnt=3;
var selection = {
    element: null,
    visible : false,
    allow: false,
    x: 0,
    y: 0,
    startX: 0,
    startY: 0,
    width: 0,
    height: 0,

    updateCSS: function(){
        this.element.css({
            left:this.x,
            top:this.y,
            width: this.width,
            height: this.height
        });

        this.element.css("background-position", "-" + (selection.x-leftMargin) + "px -" + (selection.y-topMargin) +"px");
        if(this.width > 5 && this.height > 5){
            if(this.element.css("display") == "none") {
                this.element.css("display", "block");
                this.visible = true;
            }
        } else {
            if(this.element.css("display") == "block") {
                this.element.css("display", "none");
                this.visible = false;
            }
        }
    }
}
$.noConflict();
jQuery(document).ready(init);

function init(){
//   document.onselectstart = function(){
//       return false;
//    }
    if(!window.Clipboard){
        //clipboardCatcher = jQuery(".clipboard-catcher").focus();
        //jQuery(document).bind("click", focusCC);
        clipboardCatcher = document.createElement("div");
        clipboardCatcher.setAttribute("contenteditable", "");
        clipboardCatcher.style.width = "0px";
        clipboardCatcher.style.height = "0px";
        clipboardCatcher.style.overflow = "hidden";
        document.body.appendChild(clipboardCatcher);
        //clipboardCatcher.focus();

//        document.addEventListener("click", function() {
//            clipboardCatcher.focus();
//        });
    }

    window.addEventListener("paste", onPasteHandler);

    upText = jQuery(".up-text");
    fadePane = jQuery(".fade-pane");
    statusText = jQuery(".status-text");
    infoText = jQuery(".info");
    loader = jQuery(".loader");
    holder = jQuery(".holder");
    imageContainer = jQuery(".image-container");
    leftMargin = imageContainer.offset().left;
    
    //imageContainer.mousedown(mouseDownHandler);
    //imageContainer.mousemove(mouseMoveHandler);

    selection.element = jQuery("<div>").addClass("selection").css("display", "none");
    //selection.element.mousemove(mouseMoveHandler);
//    jQuery("body").mouseup(mouseUpHandler);
//    jQuery("body").append(selection.element);
    //jQuery(".upload-button").click(upload);
    jQuery("#upload").click(save);
    jQuery("#cancel").click(cancelSave);
}

function checkInput() {
    var child = clipboardCatcher.childNodes[0];
    //debug(clipboardCatcher.innerHTML);
    clipboardCatcher.innerHTML = "";
    if(child) {
        if(child.tagName === "IMG") {
            createImage(child.src);
            //jQuery(document).unbind("click", focusCC);
        } else {
            noImageError();
        }
    } else {
        noImageError();
    }

}


/**
 * Comment
 */
function addScreenshot() {
    if (cnt < maxCnt) {
		focusCC();
        loader.show();
        isPasting = true;
    }
}


function focusCC(){
    if(clipboardCatcher) {
        clipboardCatcher.focus();
    }
}

function fadePaneOut(){
    changeText(upText, "Image");
    fadePane.fadeOut(400);
}

function fadePaneIn(){
    changeText(upText, "Selection");
    fadePane.fadeIn(400);
}

function changeText(element,text){
    element.fadeOut(300, function(){
        if(!element.hasClass("hidden")){
            element.html(text).fadeIn(300);
        }
    });
}


function onPasteHandler(e){
    
    if(e.clipboardData && isPasting) {
        var items = e.clipboardData.items;
        if(!items){
            incompatibleBrowserError();
            return;
        }
        var urlObj = window.URL || window.webkitURL;
        var containsImage = false;

        for (var i = 0; i < items.length; ++i) {
            if (items[i].kind === 'file' && items[i].type === 'image/png') {
                containsImage = true;
                var blob = items[i].getAsFile();
                var source = window.webkitURL.createObjectURL(blob);
                createImage(source);
            }
        }

        if(!containsImage){
            noImageError();
        } else {
            //changeText(statusText, "Tip: Click and drag to select an area of the image.");
        }
    } else {
//setTimeout(checkInput, 1);
}
}

function noImageError(){
    //changeText(statusText,"<span class='large bold inset'>No image found!</span><br/><p> Copy an image to your clipboard <br/>and paste again. </p>");
    //changeText(statusText,"No image found! Copy an image to your clipboard and paste again.");
	changeText(statusText,"no screenshot in clipboard");
}

function incompatibleBrowserError(){
    changeText(infoText, "<span class='large bold inset'>Incompatible Browser!</span><br/> <p>Try out the <a href='java/'>Java version</a>.</p>");
}

function createImage(source){
    pastedImage = new Image();
    pastedImage.src = source;
    pastedImage.onload = function(){
        selection.element.fadeOut(300);
        imageContainer.css({
            background: "url('"+ source + "')",
            width: pastedImage.width,
            height: pastedImage.height
        });
        imageContainer.fadeIn(1000, function () {
            selection.allow = true;
        });
        selection.element.css("background", "url('" + pastedImage.src + "') no-repeat");
        createGrayscale();
    };

}

function createGrayscale(){

    var canvas = document.createElement("canvas");
    var ctx = canvas.getContext("2d");
    canvas.width = pastedImage.width;
    canvas.height = pastedImage.height;
    ctx.drawImage(pastedImage,0,0);
    var imageData = ctx.getImageData(0,0,pastedImage.width, pastedImage.height);
    grayscale(imageData);
    ctx.putImageData(imageData,0,0);
    fadePane.css({
        background: "url('"+ canvas.toDataURL() + "')"
    });
}

function grayscale(input){
    var width = input.width, height = input.height;
    var inputData = input.data;
    for (var y = 0; y < height; y++) {
        for (var x = 0; x < width; x++) {
            var pixel = (y*width + x)*4;
            var luma = inputData[pixel]*0.3 + inputData[pixel+1]*0.59 + inputData[pixel+2]*0.11;
            inputData[pixel] = inputData[pixel+1] = inputData[pixel+2] = luma;
        }
    }
}

function mouseDownHandler(e){
    focusCC();

    if(selection.allow){
        mouseDown = true;
        selection.startX = selection.x = e.pageX;
        selection.startY = selection.y = e.pageY;
        selection.width = 0;
        selection.height = 0;
        fadePaneIn();
        selection.updateCSS();
    }

}

function mouseMoveHandler(e){
    if(mouseDown){
        selection.width = e.pageX - selection.startX;
        selection.height = e.pageY - selection.startY;

        if(selection.width < 0){
            selection.width *= -1;
            selection.x = selection.startX - selection.width;
        }

        if(selection.height < 0){
            selection.height *= -1;
            selection.y = selection.startY - selection.height;
        }

        selection.updateCSS();
    }
}

function mouseUpHandler(e){
    focusCC();
    mouseDown = false;

    if(pastedImage){
        if(selection.width < 5 && selection.height < 5){
            selection.element.css("display", "none");
            fadePaneOut();
            selection.visible = false;
        }
    }
}

function upload(){
    var canvas = document.createElement("canvas");
    var ctx = canvas.getContext("2d");

    var url;

    if(selection.visible){
        canvas.width = selection.width;
        canvas.height = selection.height;
        ctx.drawImage(pastedImage,-selection.x+leftMargin,-selection.y+topMargin);
    } else {
        canvas.width = pastedImage.width;
        canvas.height = pastedImage.height;
        ctx.drawImage(pastedImage,0,0);
    }
    

    url = canvas.toDataURL();
    url = url.substring(url.indexOf("iVBOR"));
    changeText(statusText, "Uploading image...");

    //selection.allow = false;


    try{
        jQuery.ajax({
            type: "POST",
            url: "server/upload.php",
            data:{
                URL: url,
                quality: 90
            },
            success:function(response){
                changeText(statusText, "Image uploaded to <input class='link-box' onClick='this.select();' type='text' value='" + response + "'/>" );
                selection.allow = true;
            },
            error:function (xhr, ajaxOptions, thrownError){
                changeText(statusText, "Error while load an image ("+thrownError+")...");
            }
        });
    }
    catch (e)
    {
        changeText(statusText, "Error while load an image...");
    }
/**

    try {
        $.post("server/upload.php",
        {
            URL: url,
            quality: 90
        },

        function(data){
            changeText(statusText, "Image uploaded to <input class='link-box' onClick='this.select();' type='text' value='" + data + "'/>" );
            selection.allow = true;
        });

    } catch (exception) {
        changeText(statusText, "Error while load an image...");
    }

**/
    
}

function save(){
    var canvas = document.createElement("canvas");
    var ctx = canvas.getContext("2d");
    var url;

    if(selection.visible){
        canvas.width = selection.width;
        canvas.height = selection.height;
        ctx.drawImage(pastedImage, -selection.x + leftMargin, -selection.y + topMargin);
    } else {
        canvas.width = pastedImage.width;
        canvas.height = pastedImage.height;
        ctx.drawImage(pastedImage,0,0);
    }

    url = canvas.toDataURL();
    cropUrl = url.substring(url.indexOf("iVBOR"));
    var c = cnt++;
    holder.append("<div class=\"screenshot-thumb\" style=\"background:url('"+url+"') center no-repeat\"><input type=\"hidden\" name=\"attachments[screenshot"+c+"][content]\" value=\""+cropUrl+"\"><input type=\"hidden\" name=\"attachments[screenshot"+c+"][name]\" value=\"screenshot"+c+"\"/></div>");
    
    
    closeLoader();
    return false;
}
/**
 *
 */
function cancelSave() {
    closeLoader();
    return false;
}

/**
 * Comment
 */
function closeLoader() {
    isPasting = false;
    selection.allow = true;
    selection.visible = false;
//    fadePaneOut();
    selection.element.css("display", "none");
    loader.hide();
    imageContainer.css({
        background: "",
        width:"0",
        height:"0"
    });
}

function debug(arguments){
    console.log(arguments);
}