require 'redmine'
require 'base64'
require 'dispatcher'

require_dependency 'redmine_cr_img_paste/screenshot'

Redmine::Plugin.register :redmine_cr_img_paste do
  name 'Screenshots'
  author 'Alexandr Ivanov'
  description 'Screenshot paster based on JavaSript. Paste an image from clipboard. GoogleChrome browser recomended'
  version '0.1.0'
  url ''
  author_url 'solo12zw74 at gmail.com'
end


class Screenshot
    def initialize(content, name)
	@raw = StringIO.new(Base64.decode64(content.to_s))
	@name = name.to_s.strip
        @name = "screenshot" if @name.blank?
	@name << ".png"
    end
                      
    def size
        @raw.size
    end
                                
    def original_filename
	@name
    end
                                          
    def content_type
	"image/png"
    end
                                                    
    def read(*args)
	@raw.read(*args)
    end
end
                        
module RedmineScreenshots
    def self.included(base)
	base.send(:extend, ClassMethods)
	base.class_eval do
	    class << self
		alias_method_chain :attach_files, :screenshot
	    end
	end
    end
                                                                                                
    module ClassMethods
	def attach_files_with_screenshot(obj, attachments)
	    if attachments && attachments.is_a?(Hash)
		attachments.each do |key,value|
		    next unless key.start_with?('screenshot')
	    	    value['file'] = Screenshot.new(value.delete('content'),value.delete('name'))
	    	end
    	    end
    	    attach_files_without_screenshot(obj, attachments)
	end
    end
end
                                                                                                                                                                                                                    
Dispatcher.to_prepare :redmine_screenshot_paste do
    Attachment.send :include, RedmineScreenshots
end
                                                                                                                                                                                                                      