# 簡単親子設定

ドラッグ&ドロップでチケットの親子関係を簡単に設定できるRedmineプラグインです。

## 要件

- Redmine 4.0以上

## 機能

- ドラッグ&ドロップによる直感的な親子関係設定
- 複数の親チケットと子チケットの管理
- フィルター機能によるチケット絞り込み
- 変更の保存・リセット機能
- Redmine標準UIとの統一デザイン
- **親子関係の切断**: 子チケットの切断ボタンで、チケットとその子孫を独立したツリーとして分離

## インストール

1. プラグインディレクトリ（`plugins/redmine_easy_parent_child`）に配置
2. Redmineを再起動
3. プロジェクト設定で「簡単親子設定」モジュールを有効化

> **注意**: このプラグインはRedmine標準のデータベース構造のみを使用するため、マイグレーションの実行は不要です。

## 使用方法

### 親子関係の設定

1. プロジェクトメニューから「簡単親子設定」を選択
2. フィルターで表示するチケットを絞り込み
3. 左側のチケットを右側の親または子エリアにドラッグ
4. 「保存」ボタンで変更を確定

### 親子関係の切断

ツリービュー（左側）の子チケットに表示される「切断」ボタンをクリックすることで、親子関係を切断できます。

**動作仕様:**
- 子チケットの「切断」ボタンをクリックすると、そのチケットとそのすべての子孫が独立したツリーとして分離されます
- 例：A - B - C - D - E という親子関係がある場合、Cの切断ボタンをクリックすると以下のように分かれます：
  - A - B（元のツリー）
  - C - D - E（分離されたツリー）
- 切断されたチケットはルートチケット（親なし）となり、そのすべての子孫は引き続きそのチケットの子として保持されます

**操作手順:**
1. ツリービュー（左側）で切断したい子チケットを見つける
2. そのチケットの「切断」ボタンをクリック
3. 確認ダイアログで操作を確認
4. 親子関係が切断され、ページがリロードされて更新されたツリー構造が表示されます

## パッケージ化

配布用のZIPファイルを作成するには、プラグインディレクトリで以下のコマンドを実行してください。

### PowerShellスクリプトを使用する場合

```powershell
.\package.ps1
```

バージョンを指定する場合:

```powershell
.\package.ps1 -Version "1.0.0"
```

出力先を指定する場合:

```powershell
.\package.ps1 -Version "1.0.0" -OutputDir "..\releases"
```

### バッチファイルを使用する場合

```cmd
package.bat
```

バージョンを指定する場合:

```cmd
package.bat 1.0.0
```

出力先を指定する場合:

```cmd
package.bat 1.0.0 ..\releases
```

### パッケージ化時の除外ファイル

以下のファイル/ディレクトリは自動的に除外されます:

- `.git/`, `.gitignore`, `.gitattributes`
- `*.log`, `log/`, `tmp/`
- `.DS_Store`, `Thumbs.db`
- `node_modules/`
- `.vs/`, `.vscode/`, `.idea/`
- `*.swp`, `*.swo`, `*~`
- `.env`, `.env.local`
- `package.ps1`, `package.bat`, `temp_package/`

### 作成されるファイル

- `redmine_easy_parent_child-v{バージョン}.zip` - プラグインのZIPパッケージ

## ライセンス

GPL v2
