# Redmine-Joomla Authentication Source
#
# Copyright (C) 20112 Prieco S.A.
# Websites: http://www.prieco.com
# Technical Support:  Forum - http://www.prieco.com/en/forum/index.html
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

# Please, check http://www.redmine.org/projects/redmine/wiki/Alternativecustom_authentication_HowTo
# 
 
class MyAppCustomDB_ActiveRecord < ActiveRecord::Base
  PAUSE_RETRIES = 5
  MAX_RETRIES = 50
end

# Subclass AuthSource
class Joomla < AuthSource

  # authentication() implementation
  # - Redmine will call this method, passing the login and password entered
  #   on the Sign In form.
  #
  # +login+ : what user entered for their login
  # +password+ : what user entered for their password
  def authenticate(login, password)
    retVal = nil
    unless(login.blank? or password.blank?)
      # Get a connection to the authenticating database.
      # - Don't use ActiveRecord::Base when using establish_connection() to get at
      #   your alternative database (leave Redmine's current connection alone).
      #   Use class you prepped above.
      # - Recall that the values stored in the fields of your auth_sources
      #   record are available as self.fieldName

      # First, get the DB Adapter name and database to use for connecting:
      adapter, dbName = self.base_dn.split(':')

      # Second, try to get a connection, safely dealing with the MySQL<->ActiveRecord
      # failed connection bug that can still arise to this day (regardless of 
      # reconnect, oddly).
      retryCount = 0
      begin
        connPool = MyAppCustomDB_ActiveRecord.establish_connection(
          :adapter  => adapter,
          :host     => self.host,
          :port     => self.port,
          :username => self.account,
          :password => self.account_password,
          :database => dbName,
          :reconnect => true
        )
        db = connPool.checkout()
      rescue => err # for me, always due to dead connection; must retry bunch-o-times to get a good one if this happens
        if(retryCount < MyAppCustomDB_ActiveRecord::MAX_RETRIES)
          sleep(1) if(retryCount < MyAppCustomDB_ActiveRecord::PAUSE_RETRIES)
          retryCount += 1
          connPool.disconnect!
          retry # start again at begin
        else # too many retries, serious, reraise error and let it fall through as it normally would in Rails.
          raise
        end
      end

      # Third, query the alternative authentication database for needed info. SQL
      # sufficient, obvious, and doesn't require other setup/LoC. Even more the
      # case if we have our database engine compute our digests (here, the whole
      # username is a salt). SQL also nice if your alt auth database doesn't have
      # AR classes and is not part of a Rails app, etc.
      resultRow = db.select_one(
        "SELECT #{self.attr_login}, #{self.attr_firstname}, #{self.attr_lastname}, #{self.attr_mail} " +
        "FROM cw6az_users " +
        "WHERE SUBSTRING_INDEX( `password` , ':', 1 ) = MD5(CONCAT('#{db.quote_string(password)}', SUBSTRING_INDEX( `password` , ':', -1 )))" 
      )

      unless(resultRow.nil? or resultRow.empty?)
        user = resultRow[self.attr_login]
        unless(user.nil? or user.empty?)
          # Found a record whose login & password digest matches that computed
          # from Sign Inform parameters. If allowing Redmine to automatically
          # register such accounts in its internal table, return account
          # information to Redmine based on record found.
          retVal =
          {
            :firstname => resultRow[self.attr_firstname],
            :lastname => '<i class="lastname"></i>',
            :mail => resultRow[self.attr_mail],
            :auth_source_id => self.id
          } if(onthefly_register?)
        end
      end
    end
    # Check connection back into pool.
    connPool.checkin(db)
    return retVal
  end

  def auth_method_name
    "ExtlyMainSite" 
  end
end
