module ShowDescriptionsPatch
  # Patches Redmine's IssuesController dynamically.
  module IssuesControllerPatch
    def self.included(base) # :nodoc:
      base.send(:include, InstanceMethods)
      
      # Same as typing in the class
      base.class_eval do
        unloadable # Send unloadable so it will not be unloaded in development
        
        alias_method_chain :retrieve_query, :show_desc
      end
    end
    
    module InstanceMethods
      def retrieve_query_with_show_desc
        retrieve_query_without_show_desc
        if params[:query]
          @query.show_desc = params[:query][:show_desc] == "1" ? true : false
        end
      end
    end
  end
end
