require 'redmine'
require 'dispatcher'
require 'show_descriptions_patch'

# Patches to the Redmine core.
require 'dispatcher'

Dispatcher.to_prepare :redmine_show_descriptions do
  require_dependency 'issues_controller'
  # Guards against including the module multiple time (like in tests)
  # and registering multiple callbacks  
  unless IssuesController.included_modules.include? ShowDescriptionsPatch::IssuesControllerPatch
    IssuesController.send(:include, ShowDescriptionsPatch::IssuesControllerPatch)
  end
end

Redmine::Plugin.register :redmine_show_descriptions do
  name 'Redmine Show Descriptions plugin'
  author 'Alexandr Poplavsky'
  description 'Show full issue descriptions in the issues list'
  version '0.0.2'
  
  # Should work only on Redmine 1.0.1 and higher
  requires_redmine :version_or_higher => '1.0.1'
end
