#!/bin/sh
### BEGIN INIT INFO
# Provides:          redmine
# Required-Start:    $remote_fs $syslog
# Required-Stop:     $remote_fs $syslog
# Should-Start:      $network
# Should-Stop:       $network
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Start redmine at boot time
### END INIT INFO

REDMINE_MONGREL_CONFIG=/etc/mongrel/redmine-cluster.yml
case "$1" in
	 start)
	   mongrel_rails cluster::start -C $REDMINE_MONGREL_CONFIG
	   RETVAL=$?
   ;;
	 stop)
	   mongrel_rails cluster::stop -C $REDMINE_MONGREL_CONFIG
	   RETVAL=$?
   ;;
	 restart)
	   mongrel_rails cluster::restart -C $REDMINE_MONGREL_CONFIG
	   RETVAL=$?
   ;;
	 *)
	   echo "Usage: redmine {start|stop|restart}"
	   RETVAL=1
   ;;
esac
exit $RETVAL 
